/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.configurations.processor;

import com.aptana.configurations.ConfigurationsPlugin;
import com.aptana.configurations.ConfigurationsUtil;
import com.aptana.configurations.processor.ConfigurationProcessorsRegistry;
import com.aptana.configurations.processor.ConfigurationStatus;
import com.aptana.configurations.processor.IConfigurationProcessor;
import com.aptana.configurations.processor.IConfigurationProcessorDelegate;
import com.aptana.configurations.processor.IConfigurationProcessorListener;
import com.aptana.configurations.processor.Messages;
import com.aptana.core.ShellExecutable;
import com.aptana.core.logging.IdeLog;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConfigurationProcessor
implements IConfigurationProcessor {
    protected ConfigurationStatus configurationStatus;
    protected ListenerList listeners = new ListenerList(1);
    protected static final String CONFIG_ATTR = "configurations";
    protected static final String COMPATIBILITY_OK = "ok";
    protected static final String COMPATIBILITY_UPDATE = "update";
    protected static final String ITEM_EXISTS = "exists";
    protected static final String YES = "yes";
    protected static final String NO = "no";
    protected static final String ITEM_VERSION = "version";
    protected static final String ITEM_COMPATIBILITY = "compatibility";
    protected static final String ITEM_VERSION_OUTPUT = "rawOutput";
    private String processorID;
    private String processorName;
    private String[] categories;
    protected String[] urls;
    protected Map<String, String> attributesMap;
    protected Expression enablementExpression;

    public void setID(String processorID) {
        if (this.processorID != null) {
            throw new IllegalStateException("The processor id was already set for this processor!");
        }
        this.processorID = processorID;
        this.loadStatus();
    }

    @Override
    public String getID() {
        return this.processorID;
    }

    public void setEnablement(Expression enablementExpression) {
        this.enablementExpression = enablementExpression;
    }

    @Override
    public boolean isEnabled() {
        boolean enabled = ConfigurationsUtil.evaluateEnablement(this.enablementExpression);
        return enabled && this.hasEnabledDelegates();
    }

    public void setName(String processorName) {
        if (this.processorName != null) {
            throw new IllegalStateException("The processor name was already set for this processor!");
        }
        this.processorName = processorName;
    }

    @Override
    public String getName() {
        return this.processorName;
    }

    @Override
    public ConfigurationStatus getStatus(IProgressMonitor progressMonitor, Object attributes, boolean refresh) {
        if (!refresh) {
            return this.configurationStatus;
        }
        this.configurationStatus = this.computeStatus(progressMonitor, attributes);
        return this.configurationStatus;
    }

    @Override
    public void addConfigurationProcessorListener(IConfigurationProcessorListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removeConfigurationProcessorListener(IConfigurationProcessorListener listener) {
        this.listeners.remove((Object)listener);
    }

    protected void notifyListeners(Set<String> attributes) {
        Object[] processorListeners;
        Object[] objectArray = processorListeners = this.listeners.getListeners();
        int n = processorListeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            ((IConfigurationProcessorListener)obj).configurationStateChanged(this.configurationStatus, attributes);
            ++n2;
        }
    }

    public void setCategories(String[] categories) {
        this.categories = categories;
    }

    public String[] getCategories() {
        if (this.categories == null) {
            this.categories = new String[0];
        }
        return this.categories;
    }

    public abstract ConfigurationStatus computeStatus(IProgressMonitor var1, Object var2);

    @Override
    public abstract ConfigurationStatus configure(IProgressMonitor var1, Object var2);

    public static String getShellPath() {
        try {
            IPath path = ShellExecutable.getPath();
            if (path != null) {
                return path.toOSString();
            }
        }
        catch (CoreException e) {
            IdeLog.logWarning((Plugin)ConfigurationsPlugin.getDefault(), (Throwable)e);
        }
        return null;
    }

    protected boolean hasEnabledDelegates() {
        Set<IConfigurationProcessorDelegate> delegates = ConfigurationProcessorsRegistry.getInstance().getProcessorDelegators(this.getID());
        if (!delegates.isEmpty()) {
            for (IConfigurationProcessorDelegate delegate : delegates) {
                if (!delegate.isEnabled()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    protected void loadStatus() {
        if (this.getID() == null) {
            throw new IllegalStateException("Could not create/load a configuration status before setting the configuration processor id!");
        }
        this.configurationStatus = new ConfigurationStatus(this.getID(), this);
    }

    protected void applyErrorAttributes(String msg) {
        if (msg != null) {
            this.configurationStatus.setAttribute("error", msg);
        }
        this.configurationStatus.setStatus("error");
    }

    protected void clearErrorAttributes() {
        this.configurationStatus.removeAttribute("error");
    }

    protected IStatus loadAttributes(Object attributes) {
        if (!(attributes instanceof Object[])) {
            return this.createErrorStatus(String.valueOf(Messages.AbstractConfigurationProcessor_expectedArrayError) + attributes);
        }
        Object[] attrArray = (Object[])attributes;
        if (attrArray.length == 1 || attrArray.length == 2) {
            if (!(attrArray[0] instanceof Object[])) {
                return this.createErrorStatus(String.valueOf(Messages.AbstractConfigurationProcessor_expectedURLsArrayError) + attributes);
            }
            Object[] attrURL = (Object[])attrArray[0];
            if (attrURL.length == 0) {
                return this.createErrorStatus(Messages.AbstractConfigurationProcessor_emptyURLsArrayError);
            }
            this.urls = new String[attrURL.length];
            int i = 0;
            while (i < attrURL.length) {
                this.urls[i] = attrURL[i].toString();
                ++i;
            }
            if (attrArray.length == 2) {
                if (!(attrArray[1] instanceof Map)) {
                    return this.createErrorStatus(String.valueOf(Messages.AbstractConfigurationProcessor_expectedMapError) + attrArray[1]);
                }
                this.attributesMap = (Map)attrArray[1];
            } else {
                this.attributesMap = Collections.emptyMap();
            }
        }
        return Status.OK_STATUS;
    }

    protected IStatus createErrorStatus(String errorMessage) {
        return new Status(4, "com.aptana.configurations", errorMessage);
    }
}

